package extension.file;

import java.io.BufferedReader;
import java.io.FileReader;

public class EasyIni {
	private int line_num = 0;
	private String[] iniData = null;

	/**
	 * コンストラクタ.
	 * iniファイルを読み込む
	 * @param iniFilePath
	 */
	public EasyIni(String iniFilePath) {
		iniData = new String[200];
		FileReader fr = null;
		BufferedReader br = null;

		try {
			fr = new FileReader(iniFilePath);
			br = new BufferedReader(fr);

			String line = null;
			// ファイルを行ごとに読み込み終了したらnullが返る
			while(true){
				line = br.readLine();
				if(line == null) {
					break;
				}
				iniData[line_num++] = line;
			}

		} catch (Exception e) {
			throw new RuntimeException(e);
		} finally {
			try {
				fr.close();
				br.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public String getPro(String key) {
		String iniParam = null;
		for(int i = 0;i < line_num;i++) {
			String line = iniData[i];
			if("".equals(line) || line.charAt(0) == ';') {
				continue;
			}
			String[] lineData = line.split("=");
			if(lineData.length != 2) {
				continue;
			}
			String iniKey = lineData[0].trim();
			if(!iniKey.equals(key)) {
				continue;
			}
			iniParam = lineData[1].trim();
			break;
		}
		return iniParam;
	}

}
